<?php
include(TEMPLATEPATH.'/includes/controlpanel/controlpanel.php');
$cpanel = new Panel();
if ( function_exists('register_sidebar') )
     register_sidebar(array(
	    'name' => 'Sidebar WIDGETS',
	    'before_widget' => '<div class="inrbox">',
        'after_widget' => '<div class="inbotbg"></div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
    ));
if (function_exists('mdv_recent_comments')) { 
}else{



function mdv_recent_comments($no_comments = 5, $comment_lenth = 15, $before = '<li>', $after = '</li>', $show_pass_post = false, $comment_style = 0) {
	    global $wpdb;
	    $request = "SELECT ID, comment_ID, comment_content, comment_author, comment_author_url, comment_author_email, post_title FROM $wpdb->comments LEFT JOIN $wpdb->posts ON $wpdb->posts.ID=$wpdb->comments.comment_post_ID WHERE post_status IN ('publish','static') ";
		if(!$show_pass_post) $request .= "AND post_password ='' ";
		$request .= "AND comment_approved = '1' ORDER BY comment_ID DESC LIMIT $no_comments";
		$comments = $wpdb->get_results($request);
	    $output = '';
		if ($comments) {
			foreach ($comments as $comment) {
				$comment_author = stripslashes($comment->comment_author);
				if ($comment_author == "")
					$comment_author = "anonymous"; 
				$comment_content = strip_tags($comment->comment_content);
				$comment_content = stripslashes($comment_content);
				$words=split(" ",$comment_content); 
				$comment_excerpt = join(" ",array_slice($words,0,$comment_lenth));
				$permalink = get_permalink($comment->ID)."#comment-".$comment->comment_ID;
				$emailc = $comment->comment_author_email;
	
				if ($comment_style == 1) {
					$post_title = stripslashes($comment->post_title);
					
					$url = $comment->comment_author_url;
	
					if (empty($url))
						$output .= $before . $comment_author . ' on ' . $post_title . '.' . $after;
					else
						$output .= $before . '<a href="'.$url.'" rel="nofollow">'.$comment_author.'</a> on ' . $post_title . '.' . $after;
				}
				else {
					$output .= $before . '<div class="arthumb">' . get_avatar($emailc, $size="35") . '</div><div class="ardesc"><a href="' . $permalink;
					$output .= '" title="View the entire comment by ' . $comment_author.'">' . $comment_excerpt.'</a><p class="artd">by '. $comment_author .'</p></div>' . $after;
				}
			}
			$output = convert_smilies($output);
		} else {
			$output .= $before . "None found" . $after;
		}
	    echo $output;
	}
}

function mdv_recent_posts($no_posts = 5, $before = '<li>', $after = '</li>', $hide_pass_post = true, $skip_posts = 0, $show_excerpts = false) { 
    global $wpdb; 
        $time_difference = get_settings('gmt_offset'); 
        $now = gmdate("Y-m-d H:i:s",time()); 
    $request = "SELECT ID, post_title, post_excerpt FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'post' "; 
        if($hide_pass_post) $request .= "AND post_password ='' "; 
        $request .= "AND post_date_gmt < '$now' ORDER BY post_date DESC LIMIT $skip_posts, $no_posts"; 
    $posts = $wpdb->get_results($request); 
        $output = ''; 
    if($posts) { 
                foreach ($posts as $post) { 
                        $post_title = stripslashes($post->post_title);
                        $permalink = get_permalink($post->ID); 
                        $output .= $before . '<a href="' . $permalink . '" rel="bookmark" title="Permanent Link: ' . htmlspecialchars($post_title, ENT_COMPAT) . '">' . htmlspecialchars($post_title) . '</a>'; 
                        if($show_excerpts) { 
                                $post_excerpt = stripslashes($post->post_excerpt); 
                                $output.= '<br />' . $post_excerpt; 
                        } 
                        $output .= $after; 
                } 
        } else { 
                $output .= $before . "None found" . $after; 
        } 
    echo $output; 
} 



function my_post_limit($limit) {
	global $paged, $myOffset;
	if (empty($paged)) {
			$paged = 1;
	}
	$postperpage = intval(get_option('posts_per_page'));
	$pgstrt = ((intval($paged) -1) * $postperpage) + $myOffset . ', ';
	$limit = 'LIMIT '.$pgstrt.$postperpage;
	return $limit;
} //end function my_post_limit




function breadcrumbs() {

    $theFullUrl = $_SERVER["REQUEST_URI"];

    $urlArray=explode("/",$theFullUrl);

    echo '<h3>You Are Here: <em>//</em></h3> <span><a href="/">Home</a></span>';

    while (list($j,$text) = each($urlArray)) {

        $dir= '';

        if ($j > 1) {

            $i=1;

            while ($i < $j) {

                $dir .= '/' . $urlArray[$i];

                $text = $urlArray[$i];

                $i++;

            }

            if($j < count($urlArray)-1) echo '<span> &raquo; <a href="'.$dir.'">' . str_replace("-", " ", $text) . '</a></span>';

        }

    }

    echo wp_title();
}

function most_commented($no_posts = 5, $before = '<li>', $after = '</li>', $show_pass_post = false) { 
    global $wpdb; 
        $request = "SELECT ID, post_title, COUNT($wpdb->comments.comment_post_ID) AS 'comment_count' FROM $wpdb->posts, $wpdb->comments"; 
        $request .= " WHERE comment_approved = '1' AND $wpdb->posts.ID=$wpdb->comments.comment_post_ID AND post_status = 'publish'"; 
        if(!$show_pass_post) $request .= " AND post_password =''"; 
        $request .= " GROUP BY $wpdb->comments.comment_post_ID ORDER BY comment_count DESC LIMIT $no_posts"; 
    $posts = $wpdb->get_results($request); 
    $output = ''; 
        if ($posts) { 
                foreach ($posts as $post) { 
                        $post_title = stripslashes($post->post_title); 
                        $comment_count = $post->comment_count; 
                        $permalink = get_permalink($post->ID);
						$themeurl = get_stylesheet_directory_uri();
						$mostcscreen = get_post_meta($post->ID, 'screen', $single = true);
						if ($mostcscreen == '') { 
						$output .= $before . '<div class="mcthumb"><img src="' . $themeurl .'/images/nophoto40.png" alt="thumb" /></div>       <div class="mcdesc"><a href="' . $permalink . '">' . $post_title . '</a><p class="mctd">Article has ' . $comment_count.' comments</p></div>' . $after;
						} else {
                        $output .= $before . '<div class="mcthumb"><img src="' . $themeurl .'/timthumb.php?src=' . $mostcscreen .  '&amp;h=40&amp;w=40&amp;zc=1" alt="thumb" /></div>       <div class="mcdesc"><a href="' . $permalink . '">' . $post_title . '</a><p class="mctd">Article has ' . $comment_count.' comments</p></div>' . $after; }
                } 
        } else { 
                $output .= $before . "None found" . $after; 
        } 
    echo $output; 
} 


// Page Navigation
function wp_pagenavi($before = '', $after = '', $prelabel = '', $nxtlabel = '', $pages_to_show = 5, $always_show = false) {
	global $request, $posts_per_page, $wpdb, $paged;
	if(empty($prelabel)) {
		$prelabel  = '<strong>&laquo;</strong>';
	}
	if(empty($nxtlabel)) {
		$nxtlabel = '<strong>&raquo;</strong>';
	}
	$half_pages_to_show = round($pages_to_show/2);
	if (!is_single()) {
		if(!is_category()) {
			preg_match('#FROM\s(.*)\sORDER BY#siU', $request, $matches);		
		} else {
			preg_match('#FROM\s(.*)\sGROUP BY#siU', $request, $matches);		
		}
		$fromwhere = $matches[1];
		$numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");
		$max_page = ceil($numposts /$posts_per_page);
		if(empty($paged)) {
			$paged = 1;
		}
		if($max_page > 1 || $always_show) {
			echo "$before <div class='Nav'><span>Go to page: </span>";
			if ($paged >= ($pages_to_show-1)) {
				echo '<a href="'.get_pagenum_link().'">&laquo; First</a> ... ';
			}
			previous_posts_link($prelabel);
			for($i = $paged - $half_pages_to_show; $i  <= $paged + $half_pages_to_show; $i++) {
				if ($i >= 1 && $i <= $max_page) {
					if($i == $paged) {
						echo "<strong class='on'>$i</strong>";
					} else {
						echo ' <a href="'.get_pagenum_link($i).'">'.$i.'</a> ';
					}
				}
			}
			next_posts_link($nxtlabel, $max_page);
			if (($paged+$half_pages_to_show) < ($max_page)) {
				echo ' ... <a href="'.get_pagenum_link($max_page).'">Last &raquo;</a>';
			}
			echo "<div class='NavEnd'></div></div> $after";
		}
	}
}

function boxoutput($input) {
	$output = preg_replace('/[^0-9a-z\`\~\!\@\#\$\%\^\*\(\)\; \,\.\'\/\_\-]/i', '', substr($input, 0, 170));
	echo $output;
}

function mboxoutput($input) {
	$output = preg_replace('/[^0-9a-z\`\~\!\@\#\$\%\^\*\(\)\; \,\.\'\/\_\-]/i', '', substr($input, 0, 130));
	echo $output;
}

function new_excerpt_length($length) {
	return 50;
}
add_filter('excerpt_length', 'new_excerpt_length');

function commentstemplate($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
     <div id="comment-<?php comment_ID(); ?>">
      <div class="comment-author vcard">
         <?php echo get_avatar($comment,$size='40',$default='<path_to_url>' ); ?>
         <div class="allc">
         <?php printf(__('<span class="says">%s</span>'), get_comment_author_link()) ?>
         <div class="comment-meta commentmetadata"><span><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)'),'  ','') ?></span>  &raquo; <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></div>
        </div> 
      </div>
      <?php if ($comment->comment_approved == '0') : ?>
         <em><?php _e('<small class="moder">Your comment is awaiting moderation.</small>') ?></em>
         <br />
      <?php endif; ?>
      <div class="comtext">
      <?php comment_text() ?>
      </div> 
     </div>
<?php
        }
?>
