<?php
/* CLASS PANEL */
class Panel {
	var $default_settings = Array(
		'featuredshow' => 1,
		'colorscheme' => 'default',
		'newsletter' => 0,
		'newsletter_username' => '',
		'twitter_account' => '',
		'tweets_count' => 0,
		'featured_articles' => 0,
		'featured_category' => 1,
		'first_b_title' => 'first box',
		'first_b_url' => '#',
		'first_b_text' => '',
		'first_b_icon' => 'right_32',
		'second_b_title' => 'second box',
		'second_b_url' => '#',
		'second_b_text' => '',
		'second_b_icon' => 'right_32',
		'third_b_title' => 'third box',
		'third_b_url' => '#',
		'third_b_text' => '',
		'third_b_icon' => 'right_32',
		'fourth_b_title' => 'fourth box',
		'fourth_b_url' => '#',
		'fourth_b_text' => '',
		'fourth_b_icon' => 'right_32',
		'first_m_title' => 'first mid box',
		'first_m_url' => '#',
		'first_m_text' => '',
		'first_m_icon' => 'right_32',
	    'fade_m_title' => 'fade mid box',
		'fade_m_icon' => 'right_32',
		'fade1_m_name' => '',
		'fade1_m_url' => '#',
		'fade1_m_text' => '',
		'fade2_m_name' => '',
		'fade2_m_url' => '#',
		'fade2_m_text' => '',
		'fade3_m_name' => '',
		'fade3_m_url' => '#',
		'fade3_m_text' => '',
		'fade4_m_name' => '',
		'fade4_m_url' => '#',
		'fade4_m_text' => '',
		
	);

    /* PANEL */
	function Panel() {
		add_action('admin_menu', array(&$this, 'admin_menu'));
		add_action('admin_head', array(&$this, 'admin_head'));

		if (!is_array(get_option('AcosminBIZ')))
			
			add_option('AcosminBIZ', $this->default_settings);
			
			$this->options = get_option('AcosminBIZ');

		if (function_exists('register_sidebar'))
			register_sidebar(array('name' => 'Sidebar'));
	}
	/* PANEL END */
	
	/* 
	add_menu_page(page_title, menu_title, capability, handle, [function], [icon_url]); 
	add_submenu_page(parent, page_title, menu_title, capability required, file/handle, [function]);  
	*/
    /* WORDPRESS MENU */
	function admin_menu() {
		add_menu_page('AcosminBIZ', 'AcosminBIZ', 'edit_themes', 'AcosminBIZ', array(&$this, 'optionsmenu'), 'http://www.acosmin.com/favicon.ico');
		add_submenu_page('AcosminBIZ', 'Top Boxes', 'Top Boxes', 'edit_themes', 'AcosminBIZ-TBOX', array(&$this, 'acosmin_tboxes'));
		add_submenu_page('AcosminBIZ', 'Middle Boxes', 'Middle Boxes', 'edit_themes', 'AcosminBIZ-MBOX', array(&$this, 'acosmin_mboxes'));
	}
	/* WORDPRESS MENU END */
    
	
	/* ADMIN HEADER */
	function admin_head() { }
	/* ADMIN HEADER END */


    /* OPTIONS */
	function optionsmenu() {
		/* ACT1 */
		if ($_POST['act1'] == 'save') {
			
			if ($_POST['featuredshow_act2'] == "on") {
				$this->options["featuredshow"] = 1;
			}

			else { $this->options["featuredshow"] = 0; }
			
			if (isset($_POST['colorscheme_act2'])) {
				$this->options["colorscheme"] = $_POST['colorscheme_act2'];
			}

			else { $this->options["colorscheme"] = "default"; }
			
			if ($_POST['newsletter_act2'] == "on") {
				$this->options["newsletter"] = 1;
			}

			else { $this->options["newsletter"] = 0; }

			if ($_POST['newsletter_act2url'] != "") {
				$this->options["newsletter_username"] = $_POST['newsletter_act2url'];
			}

			else { $this->options["newsletter_username"] = ""; }
			
			if ($_POST['twitter_account_act2'] != "") {
				$this->options["twitter_account"] = $_POST['twitter_account_act2'];
			}

			else { $this->options["twitter_account"] = ""; }
			
			if (isset($_POST['tweets_count_act2'])) {
				$this->options["tweets_count"] = $_POST['tweets_count_act2'];
			}

			else { $this->options["tweets_count"] = 0; }
			
			if ($_POST['featured_articles_act2'] == "on") {
				$this->options["featured_articles"] = 1;
			}

			else { $this->options["featured_articles"] = 0; }

			if (isset($_POST['featured_category_act2'])) {
				$this->options["featured_category"] = $_POST['featured_category_act2'];
			}

			else { $this->options["featured_category"] = 1; }

			update_option('AcosminBIZ', $this->options);
			echo '<div class="wrap updated fade" id="message" style="margin-top:20px;"><p>Settings <strong>saved</strong>.</p></div>';
		}
		/* ACT1 END */
		?>

<div class="wrap">
  <script>
			function fieldSwitch(switcher,target) {
				if (document.getElementById(switcher).checked==true) {
					document.getElementById(target).disabled=false;
				}
				else {
					document.getElementById(target).disabled=true;
				}
			}
			</script>
  <h2>AcosminBIZ Options</h2>
  <form action="" method="post" class="themeform" name="Form" id="Form">
    <input type="hidden" id="act1" name="act1" value="save">
    <table class="widefat">
      <thead>
        <tr>
          <th scope="col" style="width: 40%">Design Options</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td><strong>Choose a color scheme for your theme!</strong><br />
            <small>Red, Green, Pink, Blue</small></td>
          <td><select name="colorscheme_act2" id="colorscheme_act2" style="width: 30%; margin-top: 5px;">
              <option value="default" <?php if ($this->options["colorscheme"] == "default") { echo "selected"; }?>>Default scheme</option>
              <?php
							$colorSchemes = array (
								array ('Blue','blue'),
								array ('Green','green'),
								array ('Pink','pink')
								);

							$totalSchemes = count($colorSchemes);
							$limitSchemes = $totalSchemes - 1;

							for ($scheme = 0; $scheme < $totalSchemes; $scheme++ ) {
								if (file_exists('../wp-content/themes/'.get_option('template').'/style-'.$colorSchemes[$scheme][1].'.css')) { ?>
              <option value="<?php echo $colorSchemes[$scheme][1];?>" <?php if ($this->options["colorscheme"] == $colorSchemes[$scheme][1]) { echo "selected"; }?>><?php echo $colorSchemes[$scheme][0];?> scheme</option>
              <?php }
							} ?>
            </select></td>
        </tr>
       
        <tr>
          <td><strong>Disable Featured Posts (SLIDER)</strong><br />
            </td>
          <td><input type="checkbox" name="featuredshow_act2" id="featuredshow_act2" <?php if($this->options["featuredshow"] == 1) { echo " checked"; } ?> />
            <label style="margin-left: 5px;" for="featuredshow_act2">Yes, I want to disable featured posts</label>
          </td>
        </tr>
        
      </tbody>
      <thead>
        <tr>
          <th scope="col" style="width: 40%">Newsletter, Twitter Options</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td><strong>AcosminBIZ has a custom newsletter form</strong><br />
            <small>designed for <b>Google's Feedburner service</b>. To use this service you need to know your feed's name (ex: http://feeds2.feedburner.com/<span style="color:#F00">AlexandruCosmin</span>)</small></td>
          <td><input type="checkbox" name="newsletter_act2" id="newsletter_act2" <?php if($this->options["newsletter"] == 1) { echo " checked"; } ?> onClick="fieldSwitch('newsletter_act2','newsletter_act2url');" />
            <label style="margin-left: 5px;" for="newsletter_act2">Enable custom newsletter form. Type your feed's name bellow!</label>
            <br />
            <input type="text" name="newsletter_act2url" id="newsletter_act2url" <?php if(isset($this->options["newsletter_username"]) && $this->options["newsletter_username"]!="") { echo ' value="'.$this->options["newsletter_username"].'"'; }?> style="width: 70%; margin-top: 5px;" <?php if($this->options["newsletter"] == 0) { echo " disabled"; } ?> /></td>
        </tr>
        <tr>
          <td><strong>Your Twitter account is</strong><br />
            <small>The theme needs your user name to show your latest tweets and a follow link?</small></td>
          <td><input type="text" name="twitter_account_act2" id="twitter_account_act2" <?php if(isset($this->options["twitter_account"]) && $this->options["twitter_account"]!="") { echo ' value="'.$this->options["twitter_account"].'"'; }?> style="width: 30%; margin-top: 5px;" /></td>
          </td>
        </tr>
        <tr>
          <td><strong>How many tweets to show?</strong><br />
            <small>If you want to show your latest tweets, choose how many should appear!</small></td>
          <td><select name="tweets_count_act2" id="tweets_count_act2" style="width: 30%; margin-top: 5px;">
              <option value="0" <?php if ($this->options["tweets_count"] == 0) { echo "selected"; }?>>0 tweets</option>
              <option value="3" <?php if ($this->options["tweets_count"] == 3) { echo "selected"; }?>>3 tweets</option>
              <option value="5" <?php if ($this->options["tweets_count"] == 5) { echo "selected"; }?>>5 tweets</option>
              <option value="8" <?php if ($this->options["tweets_count"] == 8) { echo "selected"; }?>>8 tweets</option>
              <option value="10" <?php if ($this->options["tweets_count"] == 10) { echo "selected"; }?>>10 tweets</option>
            </select></td>
        </tr>
      </tbody>
      <thead>
        <tr>
          <th scope="col" style="width: 40%">Featured articles options</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td><strong>Select a category for featured articles</strong><br />
            <small>Display articles from this category with the content slider!</small></td>
          <td><?php $featured_categories_obj = get_categories('hide_empty=0');
                    $featured_categories = array(); ?>
            <select name="featured_category_act2" id="featured_category_act2" style="width: 30%; margin-top: 5px;">
              <?php foreach ($featured_categories_obj as $featured_cat) { ?>
              <?php $featured_categories[$featured_cat->cat_ID] = $featured_cat->category_nicename; 
					      $catid = get_cat_ID($cat_name=$featured_cat->category_nicename); 
				    ?>
              <option value="<?php echo $catid; ?>" <?php if ($this->options["featured_category"] == $catid) { echo "selected"; }?> style="text-transform:capitalize;"><?php echo $featured_cat->category_nicename; ?></option>
              <?php } ?>
            </select></td>
        </tr>
      </tbody>
    </table>
    <p class="submit" style="text-align: right; border: none; margin: 0 0 20px 0;">
      <input type="submit" value="Update AcosminBIZ" name="save" />
    </p>
  </form>
</div>
<?php
	} /* OPTIONS END */
	
function acosmin_tboxes() { /* OPTIONS PAGE 2 */
    if ($_POST['act1'] == 'save') { /* ACT1 PAGE 2 */
			
            if ($_POST['first_b_text_act2'] != "") {
				$this->options["first_b_text"] = $_POST['first_b_text_act2'];
			}

			else { $this->options["first_b_text"] = ""; }
			
			if (isset($_POST['first_b_icon_act2'])) {
				$this->options["first_b_icon"] = $_POST['first_b_icon_act2'];
			}

			else { $this->options["first_b_icon"] = "right_32"; }
			
			if ($_POST['first_b_title_act2'] != "") {
				$this->options["first_b_title"] = $_POST['first_b_title_act2'];
			}

			else { $this->options["first_b_title"] = "first box"; }
			
			if ($_POST['first_b_url_act2'] != "") {
				$this->options["first_b_url"] = $_POST['first_b_url_act2'];
			}

			else { $this->options["first_b_url"] = "#"; }
			
			
			
			
			
			
			
			
			if ($_POST['second_b_text_act2'] != "") {
				$this->options["second_b_text"] = $_POST['second_b_text_act2'];
			}

			else { $this->options["second_b_text"] = ""; }
			
			if (isset($_POST['second_b_icon_act2'])) {
				$this->options["second_b_icon"] = $_POST['second_b_icon_act2'];
			}

			else { $this->options["second_b_icon"] = "right_32"; }
			
			if ($_POST['second_b_title_act2'] != "") {
				$this->options["second_b_title"] = $_POST['second_b_title_act2'];
			}

			else { $this->options["second_b_title"] = "second box"; }
			
			if ($_POST['second_b_url_act2'] != "") {
				$this->options["second_b_url"] = $_POST['second_b_url_act2'];
			}

			else { $this->options["second_b_url"] = "#"; }
			
			
			
			
			
			if ($_POST['third_b_text_act2'] != "") {
				$this->options["third_b_text"] = $_POST['third_b_text_act2'];
			}

			else { $this->options["third_b_text"] = ""; }
			
			if (isset($_POST['third_b_icon_act2'])) {
				$this->options["third_b_icon"] = $_POST['third_b_icon_act2'];
			}

			else { $this->options["third_b_icon"] = "right_32"; }
			
			if ($_POST['third_b_title_act2'] != "") {
				$this->options["third_b_title"] = $_POST['third_b_title_act2'];
			}

			else { $this->options["third_b_title"] = "third box"; }
			
			if ($_POST['third_b_url_act2'] != "") {
				$this->options["third_b_url"] = $_POST['third_b_url_act2'];
			}

			else { $this->options["third_b_url"] = "#"; }
			
			
			
			
			
			if ($_POST['fourth_b_text_act2'] != "") {
				$this->options["fourth_b_text"] = $_POST['fourth_b_text_act2'];
			}

			else { $this->options["fourth_b_text"] = ""; }
			
			if (isset($_POST['fourth_b_icon_act2'])) {
				$this->options["fourth_b_icon"] = $_POST['fourth_b_icon_act2'];
			}

			else { $this->options["fourth_b_icon"] = "right_32"; }
			
			if ($_POST['fourth_b_title_act2'] != "") {
				$this->options["fourth_b_title"] = $_POST['fourth_b_title_act2'];
			}

			else { $this->options["fourth_b_title"] = "fourth box"; }
			
			if ($_POST['fourth_b_url_act2'] != "") {
				$this->options["fourth_b_url"] = $_POST['fourth_b_url_act2'];
			}

			else { $this->options["fourth_b_url"] = "#"; }
			
			
			
			
			update_option('AcosminBIZ', $this->options);
			echo '<div class="wrap updated fade" id="message" style="margin-top:20px;"><p>Settings <strong>saved</strong>.</p></div>';
		} /* ACT1 PAGE 2 END */ 
			
?>
<div class="wrap">
  <h2>AcosminBIZ Top Boxes</h2>
  <form action="" method="post" class="themeform" name="Form" id="Form">
    <input type="hidden" id="act1" name="act1" value="save">
    <table class="widefat">
      <thead>
        <tr>
          <th scope="col" style="width: 40%">First box</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the first box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="first_b_title_act2" id="first_b_title_act2" <?php if(isset($this->options["first_b_title"]) && $this->options["first_b_title"]!="") { echo ' value="'.$this->options["first_b_title"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="first_b_url_act2" id="first_b_url_act2" <?php if(isset($this->options["first_b_url"]) && $this->options["first_b_url"]!="") { echo ' value="'.$this->options["first_b_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Choose an icon for this box</strong></td>
          <td style="border-bottom:1px solid #fff;"><select name="first_b_icon_act2" id="first_b_icon_act2" style="width: 30%; margin-top: 5px;">
              <option value="right_32" <?php if ($this->options["first_b_icon"] == "right_32") { echo "selected"; }?>>Default icon</option>
              <?php
							$icons_tbox_1 = array (
								array ('Address book','address_32'), array ('Block access','block_32'), array ('Bookmark','bookmark_32'), array ('Briefcase','briefcase_32'), array ('Bubble','bubble_32'), array ('Buy','buy_32'), array ('Calendar','calendar_32'), array ('Clipboard','clipboard_32'), array ('Clock','clock_32'),
 array ('Delete','delete_32'), array ('Diagram','diagram_32'), array ('Document','document_32'), array ('Down','down_32'), array ('Flag','flag_32'), array ('Folder','folder_32'), array ('Gear','gear_32'), array ('Globe','globe_32'), array ('Heart','heart_32'), array ('Help','help_32'), array ('Home','home_32'), array ('Info','info_32'), array ('Key','key_32'), array ('Label','label_32'), array ('Left','left_32'), array ('Letter','letter_32'), array ('Monitor','monitor_32'), array ('Pencil','pencil_32'), array ('Plus','plus_32'), array ('Present','present_32'), array ('Printer','print_32'), array ('Save','save_32'), array ('Search','search_32'), array ('Security','security_32'), array ('Statistics','statistics_32'), array ('Tick','tick_32'), array ('Trash','trash_32'), array ('Up','up_32'), array ('User','user_32'),
 array ('Wallet','wallet_32'), array ('Warning','warning_32'),
								);

							$total_tbox1_icons = count($icons_tbox_1);
							$limit_tbox1_icons = $total_tbox1_icons - 1;

							for ($icontbox1 = 0; $icontbox1 < $total_tbox1_icons; $icontbox1++ ) {
								if (file_exists('../wp-content/themes/'.get_option('template').'/images/icons/'.$icons_tbox_1[$icontbox1][1].'.png')) { ?>
              <option value="<?php echo $icons_tbox_1[$icontbox1][1];?>" <?php if ($this->options["first_b_icon"] == $icons_tbox_1[$icontbox1][1]) { echo "selected"; }?>><?php echo $icons_tbox_1[$icontbox1][0];?></option>
              <?php }
							} ?>
            </select></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="first_b_text_act2" id="first_b_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["first_b_text"]) && $this->options["first_b_text"]!="") { boxoutput($this->options["first_b_text"]); }?>
</textarea></td>
        </tr>
       </tbody>
    </table>
    
    
    
    <table class="widefat" style="margin-top:30px;">
      <thead>
        <tr>
          <th scope="col" style="width: 40%">Second box</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the second box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="second_b_title_act2" id="second_b_title_act2" <?php if(isset($this->options["second_b_title"]) && $this->options["second_b_title"]!="") { echo ' value="'.$this->options["second_b_title"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="second_b_url_act2" id="second_b_url_act2" <?php if(isset($this->options["second_b_url"]) && $this->options["second_b_url"]!="") { echo ' value="'.$this->options["second_b_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Choose an icon for this box</strong></td>
          <td style="border-bottom:1px solid #fff;"><select name="second_b_icon_act2" id="second_b_icon_act2" style="width: 30%; margin-top: 5px;">
              <option value="right_32" <?php if ($this->options["second_b_icon"] == "right_32") { echo "selected"; }?>>Default icon</option>
              <?php

							$total_tbox1_icons = count($icons_tbox_1);
							$limit_tbox1_icons = $total_tbox1_icons - 1;

							for ($icontbox1 = 0; $icontbox1 < $total_tbox1_icons; $icontbox1++ ) {
								if (file_exists('../wp-content/themes/'.get_option('template').'/images/icons/'.$icons_tbox_1[$icontbox1][1].'.png')) { ?>
              <option value="<?php echo $icons_tbox_1[$icontbox1][1];?>" <?php if ($this->options["second_b_icon"] == $icons_tbox_1[$icontbox1][1]) { echo "selected"; }?>><?php echo $icons_tbox_1[$icontbox1][0];?></option>
              <?php }
							} ?>
            </select></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="second_b_text_act2" id="second_b_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["second_b_text"]) && $this->options["second_b_text"]!="") { boxoutput($this->options["second_b_text"]); }?>
</textarea></td>
        </tr>
       </tbody>
    </table>
    
    
    <table class="widefat" style="margin-top:30px;">
      <thead>
        <tr>
          <th scope="col" style="width: 40%">Third box</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the third box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="third_b_title_act2" id="third_b_title_act2" <?php if(isset($this->options["third_b_title"]) && $this->options["third_b_title"]!="") { echo ' value="'.$this->options["third_b_title"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="third_b_url_act2" id="third_b_url_act2" <?php if(isset($this->options["third_b_url"]) && $this->options["third_b_url"]!="") { echo ' value="'.$this->options["third_b_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Choose an icon for this box</strong></td>
          <td style="border-bottom:1px solid #fff;"><select name="third_b_icon_act2" id="third_b_icon_act2" style="width: 30%; margin-top: 5px;">
              <option value="right_32" <?php if ($this->options["third_b_icon"] == "right_32") { echo "selected"; }?>>Default icon</option>
              <?php

							$total_tbox1_icons = count($icons_tbox_1);
							$limit_tbox1_icons = $total_tbox1_icons - 1;

							for ($icontbox1 = 0; $icontbox1 < $total_tbox1_icons; $icontbox1++ ) {
								if (file_exists('../wp-content/themes/'.get_option('template').'/images/icons/'.$icons_tbox_1[$icontbox1][1].'.png')) { ?>
              <option value="<?php echo $icons_tbox_1[$icontbox1][1];?>" <?php if ($this->options["third_b_icon"] == $icons_tbox_1[$icontbox1][1]) { echo "selected"; }?>><?php echo $icons_tbox_1[$icontbox1][0];?></option>
              <?php }
							} ?>
            </select></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="third_b_text_act2" id="third_b_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["third_b_text"]) && $this->options["third_b_text"]!="") { boxoutput($this->options["third_b_text"]); }?>
</textarea></td>
        </tr>
       </tbody>
    </table>
    
    
    
    <table class="widefat" style="margin-top:30px;">
      <thead>
        <tr>
          <th scope="col" style="width: 40%">Fourth box</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the fourth box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fourth_b_title_act2" id="fourth_b_title_act2" <?php if(isset($this->options["fourth_b_title"]) && $this->options["fourth_b_title"]!="") { echo ' value="'.$this->options["fourth_b_title"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fourth_b_url_act2" id="fourth_b_url_act2" <?php if(isset($this->options["fourth_b_url"]) && $this->options["fourth_b_url"]!="") { echo ' value="'.$this->options["fourth_b_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Choose an icon for this box</strong></td>
          <td style="border-bottom:1px solid #fff;"><select name="fourth_b_icon_act2" id="fourth_b_icon_act2" style="width: 30%; margin-top: 5px;">
              <option value="right_32" <?php if ($this->options["fourth_b_icon"] == "right_32") { echo "selected"; }?>>Default icon</option>
              <?php

							$total_tbox1_icons = count($icons_tbox_1);
							$limit_tbox1_icons = $total_tbox1_icons - 1;

							for ($icontbox1 = 0; $icontbox1 < $total_tbox1_icons; $icontbox1++ ) {
								if (file_exists('../wp-content/themes/'.get_option('template').'/images/icons/'.$icons_tbox_1[$icontbox1][1].'.png')) { ?>
              <option value="<?php echo $icons_tbox_1[$icontbox1][1];?>" <?php if ($this->options["fourth_b_icon"] == $icons_tbox_1[$icontbox1][1]) { echo "selected"; }?>><?php echo $icons_tbox_1[$icontbox1][0];?></option>
              <?php }
							} ?>
            </select></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="fourth_b_text_act2" id="fourth_b_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["fourth_b_text"]) && $this->options["fourth_b_text"]!="") { boxoutput($this->options["fourth_b_text"]); }?>
</textarea></td>
        </tr>
       </tbody>
    </table>
        <p class="submit" style="text-align: right; border: none; margin: 0 0 20px 0;">
      <input type="submit" value="Update AcosminSIMPLE" name="save" />
    </p>
  </form>
</div>
 
<?php
   } /* OPTIONS PAGE 2 END */
   	
function acosmin_mboxes() { /* OPTIONS PAGE 3 */
    if ($_POST['act1'] == 'save') { /* ACT1 PAGE 3 */
			
			if ($_POST['first_m_text_act2'] != "") {
				$this->options["first_m_text"] = $_POST['first_m_text_act2'];
			}

			else { $this->options["first_m_text"] = ""; }
			
			if (isset($_POST['first_m_icon_act2'])) {
				$this->options["first_m_icon"] = $_POST['first_m_icon_act2'];
			}

			else { $this->options["first_m_icon"] = "right_32"; }
			
			if ($_POST['first_m_title_act2'] != "") {
				$this->options["first_m_title"] = $_POST['first_m_title_act2'];
			}

			else { $this->options["first_m_title"] = "first mid box"; }
			
			if ($_POST['first_m_url_act2'] != "") {
				$this->options["first_m_url"] = $_POST['first_m_url_act2'];
			}

			else { $this->options["first_m_url"] = "#"; }
			
			
			
			if ($_POST['fade_m_title_act2'] != "") {
				$this->options["fade_m_title"] = $_POST['fade_m_title_act2'];
			}

			else { $this->options["fade_m_title"] = "fade mid box"; }
			
            if (isset($_POST['fade_m_icon_act2'])) {
				$this->options["fade_m_icon"] = $_POST['fade_m_icon_act2'];
			}

			else { $this->options["fade_m_icon"] = "right_32"; }
			
			
			
			if ($_POST['fade1_m_text_act2'] != "") {
				$this->options["fade1_m_text"] = $_POST['fade1_m_text_act2'];
			}

			else { $this->options["fade1_m_text"] = ""; }
			
			if ($_POST['fade1_m_name_act2'] != "") {
				$this->options["fade1_m_name"] = $_POST['fade1_m_name_act2'];
			}

			else { $this->options["fade1_m_name"] = ""; }
			
			if ($_POST['fade1_m_url_act2'] != "") {
				$this->options["fade1_m_url"] = $_POST['fade1_m_url_act2'];
			}

			else { $this->options["fade1_m_url"] = "#"; }
			
			
			
			if ($_POST['fade2_m_text_act2'] != "") {
				$this->options["fade2_m_text"] = $_POST['fade2_m_text_act2'];
			}

			else { $this->options["fade2_m_text"] = ""; }
			
			if ($_POST['fade2_m_name_act2'] != "") {
				$this->options["fade2_m_name"] = $_POST['fade2_m_name_act2'];
			}

			else { $this->options["fade2_m_name"] = ""; }
			
			if ($_POST['fade2_m_url_act2'] != "") {
				$this->options["fade2_m_url"] = $_POST['fade2_m_url_act2'];
			}

			else { $this->options["fade2_m_url"] = "#"; }
			
			
			
			
			if ($_POST['fade3_m_text_act2'] != "") {
				$this->options["fade3_m_text"] = $_POST['fade3_m_text_act2'];
			}

			else { $this->options["fade3_m_text"] = ""; }
			
			if ($_POST['fade3_m_name_act2'] != "") {
				$this->options["fade3_m_name"] = $_POST['fade3_m_name_act2'];
			}

			else { $this->options["fade3_m_name"] = ""; }
			
			if ($_POST['fade3_m_url_act2'] != "") {
				$this->options["fade3_m_url"] = $_POST['fade3_m_url_act2'];
			}

			else { $this->options["fade3_m_url"] = "#"; }
			
			
			
			
			if ($_POST['fade4_m_text_act2'] != "") {
				$this->options["fade4_m_text"] = $_POST['fade4_m_text_act2'];
			}

			else { $this->options["fade4_m_text"] = ""; }
			
			if ($_POST['fade4_m_name_act2'] != "") {
				$this->options["fade4_m_name"] = $_POST['fade4_m_name_act2'];
			}

			else { $this->options["fade4_m_name"] = ""; }
			
			if ($_POST['fade4_m_url_act2'] != "") {
				$this->options["fade4_m_url"] = $_POST['fade4_m_url_act2'];
			}

			else { $this->options["fade4_m_url"] = "#"; }
			
			update_option('AcosminBIZ', $this->options);
			echo '<div class="wrap updated fade" id="message" style="margin-top:20px;"><p>Settings <strong>saved</strong>.</p></div>';
		} /* ACT1 PAGE 2 END */ 
			
?>
<div class="wrap">
  <h2>AcosminBIZ Middle Boxes</h2>
  <form action="" method="post" class="themeform" name="Form" id="Form">
    <input type="hidden" id="act1" name="act1" value="save">
    <table class="widefat" style="margin-top:30px;">
      <thead>
        <tr>
          <th scope="col" style="width: 40%">First box</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the first box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="first_m_title_act2" id="first_m_title_act2" <?php if(isset($this->options["first_m_title"]) && $this->options["first_m_title"]!="") { echo ' value="'.$this->options["first_m_title"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="first_m_url_act2" id="first_m_url_act2" <?php if(isset($this->options["first_m_url"]) && $this->options["first_m_url"]!="") { echo ' value="'.$this->options["first_m_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Choose an icon for this box</strong></td>
          <td style="border-bottom:1px solid #fff;"><select name="first_m_icon_act2" id="first_m_icon_act2" style="width: 30%; margin-top: 5px;">
              <option value="right_32" <?php if ($this->options["first_m_icon"] == "right_32") { echo "selected"; }?>>Default icon</option>
              <?php
                            $icons_tbox_1 = array (
								array ('Address book','address_32'), array ('Block access','block_32'), array ('Bookmark','bookmark_32'), array ('Briefcase','briefcase_32'), array ('Bubble','bubble_32'), array ('Buy','buy_32'), array ('Calendar','calendar_32'), array ('Clipboard','clipboard_32'), array ('Clock','clock_32'),
 array ('Delete','delete_32'), array ('Diagram','diagram_32'), array ('Document','document_32'), array ('Down','down_32'), array ('Flag','flag_32'), array ('Folder','folder_32'), array ('Gear','gear_32'), array ('Globe','globe_32'), array ('Heart','heart_32'), array ('Help','help_32'), array ('Home','home_32'), array ('Info','info_32'), array ('Key','key_32'), array ('Label','label_32'), array ('Left','left_32'), array ('Letter','letter_32'), array ('Monitor','monitor_32'), array ('Pencil','pencil_32'), array ('Plus','plus_32'), array ('Present','present_32'), array ('Printer','print_32'), array ('Save','save_32'), array ('Search','search_32'), array ('Security','security_32'), array ('Statistics','statistics_32'), array ('Tick','tick_32'), array ('Trash','trash_32'), array ('Up','up_32'), array ('User','user_32'),
 array ('Wallet','wallet_32'), array ('Warning','warning_32'),
								);
							$total_tbox1_icons = count($icons_tbox_1);
							$limit_tbox1_icons = $total_tbox1_icons - 1;

							for ($icontbox1 = 0; $icontbox1 < $total_tbox1_icons; $icontbox1++ ) {
								if (file_exists('../wp-content/themes/'.get_option('template').'/images/icons/'.$icons_tbox_1[$icontbox1][1].'.png')) { ?>
              <option value="<?php echo $icons_tbox_1[$icontbox1][1];?>" <?php if ($this->options["first_m_icon"] == $icons_tbox_1[$icontbox1][1]) { echo "selected"; }?>><?php echo $icons_tbox_1[$icontbox1][0];?></option>
              <?php }
							} ?>
            </select></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="first_m_text_act2" id="first_m_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["first_m_text"]) && $this->options["first_m_text"]!="") { boxoutput($this->options["first_m_text"]); }?>
</textarea></td>
        </tr>
       </tbody>
    </table>
    
    
    
    <table class="widefat" style="margin-top:30px;">
      <thead>
        <tr>
          <th scope="col" style="width: 40%">Fading boxes</th>
          <th scope="col">Settings</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Main box title</strong><br />
            <small>A title for the fade box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade_m_title_act2" id="fade_m_title_act2" <?php if(isset($this->options["fade_m_title"]) && $this->options["fade_m_title"]!="") { echo ' value="'.$this->options["fade_m_title"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Choose an icon for this box</strong></td>
          <td style="border-bottom:5px solid #dfdfdf;"><select name="fade_m_icon_act2" id="fade_m_icon_act2" style="width: 30%; margin-top: 5px;">
              <option value="right_32" <?php if ($this->options["fade_m_icon"] == "right_32") { echo "selected"; }?>>Default icon</option>
              <?php

							$total_tbox1_icons = count($icons_tbox_1);
							$limit_tbox1_icons = $total_tbox1_icons - 1;

							for ($icontbox1 = 0; $icontbox1 < $total_tbox1_icons; $icontbox1++ ) {
								if (file_exists('../wp-content/themes/'.get_option('template').'/images/icons/'.$icons_tbox_1[$icontbox1][1].'.png')) { ?>
              <option value="<?php echo $icons_tbox_1[$icontbox1][1];?>" <?php if ($this->options["fade_m_icon"] == $icons_tbox_1[$icontbox1][1]) { echo "selected"; }?>><?php echo $icons_tbox_1[$icontbox1][0];?></option>
              <?php }
							} ?>
            </select></td>
        </tr>
        
        
        
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the first box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade1_m_name_act2" id="fade1_m_name_act2" <?php if(isset($this->options["fade1_m_name"]) && $this->options["fade1_m_name"]!="") { echo ' value="'.$this->options["fade1_m_name"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade1_m_url_act2" id="fade1_m_url_act2" <?php if(isset($this->options["fade1_m_url"]) && $this->options["fade1_m_url"]!="") { echo ' value="'.$this->options["fade1_m_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="fade1_m_text_act2" id="fade1_m_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["fade1_m_text"]) && $this->options["fade1_m_text"]!="") { mboxoutput($this->options["fade1_m_text"]); }?>
</textarea></td>
        </tr>
        
        
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the second box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade2_m_name_act2" id="fade2_m_name_act2" <?php if(isset($this->options["fade2_m_name"]) && $this->options["fade2_m_name"]!="") { echo ' value="'.$this->options["fade2_m_name"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade2_m_url_act2" id="fade2_m_url_act2" <?php if(isset($this->options["fade2_m_url"]) && $this->options["fade2_m_url"]!="") { echo ' value="'.$this->options["fade2_m_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="fade2_m_text_act2" id="fade2_m_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["fade2_m_text"]) && $this->options["fade2_m_text"]!="") { mboxoutput($this->options["fade2_m_text"]); }?>
</textarea></td>
        </tr>
        
        
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the third box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade3_m_name_act2" id="fade3_m_name_act2" <?php if(isset($this->options["fade3_m_name"]) && $this->options["fade3_m_name"]!="") { echo ' value="'.$this->options["fade3_m_name"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade3_m_url_act2" id="fade3_m_url_act2" <?php if(isset($this->options["fade3_m_url"]) && $this->options["fade3_m_url"]!="") { echo ' value="'.$this->options["fade3_m_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="fade3_m_text_act2" id="fade3_m_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["fade3_m_text"]) && $this->options["fade3_m_text"]!="") { mboxoutput($this->options["fade3_m_text"]); }?>
</textarea></td>
        </tr>
        
        
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>Box title</strong><br />
            <small>A title for the fourth box.</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade4_m_name_act2" id="fade4_m_name_act2" <?php if(isset($this->options["fade4_m_name"]) && $this->options["fade4_m_name"]!="") { echo ' value="'.$this->options["fade4_m_name"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr> 
        <tr>
          <td style="border-bottom:1px solid #fff;"><strong>An URL (link) for the title</strong><br />
            <small>When the title is clicked it will go to this url</small></td>
          <td style="border-bottom:1px solid #fff;">
            <input type="text" name="fade4_m_url_act2" id="fade4_m_url_act2" <?php if(isset($this->options["fade4_m_url"]) && $this->options["fade4_m_url"]!="") { echo ' value="'.$this->options["fade4_m_url"].'"'; }?> style="width: 70%; margin-top: 5px;" /></td>
        </tr>
        <tr>
          <td style="border-bottom:5px solid #dfdfdf;"><strong>Type a few words in this box</strong><br />
            <small></small></td>
          <td style="border-bottom:5px solid #dfdfdf;"><textarea name="fade4_m_text_act2" id="fade4_m_text_act2" style="width: 50%; margin: 5px 0px 5px 0px; height: 100px;" ><?php if(isset($this->options["fade4_m_text"]) && $this->options["fade4_m_text"]!="") { mboxoutput($this->options["fade4_m_text"]); }?>
</textarea></td>
        </tr>
        
       </tbody>
    </table>
        <p class="submit" style="text-align: right; border: none; margin: 0 0 20px 0;">
      <input type="submit" value="Update AcosminSIMPLE" name="save" />
    </p>
  </form>
</div>
<?php
   } /* OPTIONS PAGE 3 END */
} /* PANEL END */
?>